

DIM gl_axisspeed AS FLOAT
DIM gl_axismodifer AS FLOAT

FUNCTION setupaxes(stepspermm AS FLOAT)

    FOR axiscount = 0 TO TABLE(comms_numaxes)-1
        BASE(axiscount)
        MERGE=OFF
        UNITS = 16
        IF axiscount = 0 THEN
            'UNITS = 16 * (1/1.27)
            'STEP_RATIO(100,127)
            'STEP_RATIO(100,1000)
            'ENCODER_RATIO(127,100)
        ELSEIF axiscount = 3 THEN
            STEP_RATIO(100,1000)
        ENDIF
        ATYPE = 43
        IF (axiscount = 2) OR (VR(vr_machine) = microturnpro) THEN
            ACCEL = 100 * stepspermm
            DECEL = 100 * stepspermm
        ELSE
            ACCEL = 325 * stepspermm
            DECEL = 325 * stepspermm
        ENDIF
        CREEP = 0.5 * stepspermm

        SELECT_CASE axiscount
            CASE 0
                FS_LIMIT = TABLE(comms_xpluslimit)
                RS_LIMIT = TABLE(comms_xminuslimit)
            CASE 1
                FS_LIMIT = TABLE(comms_zpluslimit)
                RS_LIMIT = TABLE(comms_zminuslimit)
        END_CASE



        SERVO = 1
        WDOG = 1
    NEXT axiscount

ENDFUNC

FUNCTION setspindlespeed()
    DIM actual AS FLOAT
    actual = TABLE(comms_speed)
    DIM modifier AS FLOAT
    'Modify the speed by the override if not threading. Otherwise ignore the override and run at 100%
    IF TABLE(comms_eventthreading) = 0 THEN
        modifier = TABLE(table_speedoverride)/100
        actual = actual * modifier
    ENDIF

    IF (actual > TABLE(comms_maxspeed)) THEN
        actual = TABLE(comms_maxspeed)
    ELSEIF (actual < TABLE(comms_minspeed)) THEN
        actual = TABLE(comms_minspeed)
    ENDIF


    TABLE(table_speedrequest,actual)

    adjustfeedforperrev()

    'raiseevent(comms_speedoverride)
ENDFUNC

FUNCTION rampupspindle()
'Check for autotuning the spindle speed first
    IF (VR(vr_autotuned) > 0) THEN
        DAC AXIS(0) = VR(vr_slope) *TABLE(table_speedrequest) + VR(vr_intercept)
'Microturn Pro
    ELSEIF (VR(vr_machine) = microturnpro) THEN
        DAC AXIS(0) = 0.748 *TABLE(table_speedrequest) + 139.79
    ELSEIF (VR(vr_machine) = turn270pro) THEN
        'Turn270
'        DAC AXIS(0) = 0.51 *TABLE(table_speedrequest) - 64.16
        DAC AXIS(0) = 0.513276693144259 *TABLE(table_speedrequest) - 67.222720814453
    ELSE'turn370
        'DAC AXIS(0) = 0.55 * TABLE(table_speedrequest) - 2.94
        DAC AXIS(0) = (TABLE(table_speedrequest) + 12.771) /1.8488
    ENDIF
ENDFUNC

FUNCTION setdooropenjogspeed()

    FOR axiscount=0 TO 1
        BASE(axiscount)
        SPEED = finalfeed
    NEXT axiscount

    FORCE_SPEED = SPEED
    ENDMOVE_SPEED = SPEED
ENDFUNC


FUNCTION setfeedspeed()


    DIM actual AS FLOAT
    DIM modifier AS FLOAT

    modifier = TABLE(table_feedoverride)/100

    'Check if the door is open. If it is then set feed to be very slow for safety
    IF TABLE(table_dooropen) = ON THEN
        actual = 100 * TABLE(comms_steppermm) / 60
    ELSE
        actual = TABLE(comms_feed)
    ENDIF


    IF (TABLE(table_eventhoming) = 1) THEN
        modifier = 1
    ELSEIF (modifier * actual) > TABLE(comms_maxfeed) THEN
        modifier = TABLE(comms_maxfeed) / actual
    ENDIF



'    FOR axiscount=0 TO TABLE(comms_numaxes)-1
    FOR axiscount=0 TO 1
        BASE(axiscount)
        SPEED = actual
        FORCE_SPEED = SPEED
        ENDMOVE_SPEED = SPEED
        LOOKAHEAD_FACTOR = modifier
    NEXT axiscount
    TABLE(table_newfeedrequest,0)
    'PRINT "Setting the speed to be ", actual


    adjustfeedforperrev()

    ' raiseevent(comms_feedoverride)

ENDFUNC

FUNCTION adjustfeedforperrev()
    IF (TABLE(comms_perminperrev)> 0) AND (TABLE(table_eventhoming)=0) THEN

        DIM feedperrev AS FLOAT
        DIM modifier AS FLOAT

        feedperrev = TABLE(comms_feed_rev) * TABLE(comms_actualspeed) 'ActualSpindleSpeed ' faster/rev following
        modifier = TABLE(table_feedoverride)/100
        'feedperrev = feedperrev * (TABLE(comms_feedoverride) / 100)
        IF feedperrev > TABLE(comms_maxfeed) THEN feedperrev = TABLE(comms_maxfeed) 'clamp too big a feedrate

        'IF (SPEED = 40000) AND (feedperrev <>40000) THEN
        '     PRINT "Speed was 40000 but setting it to be ",feedperrev
        'ENDIF

        FOR axiscount=0 TO 1
'        FOR axiscount=0 TO TABLE(comms_numaxes)-1
            BASE(axiscount)
            SPEED = feedperrev
            FORCE_SPEED = SPEED
            ENDMOVE_SPEED = SPEED
            LOOKAHEAD_FACTOR = modifier
        NEXT axiscount

    ENDIF
ENDFUNC

FUNCTION ismachinesafe() AS BOOLEAN
    DIM dooropen AS BOOLEAN
    dooropen = TABLE(table_dooropen)

    DIM estoppressed AS BOOLEAN
    estoppressed = TABLE(table_estoppressed)

    RETURN (dooropen = OFF) AND (estoppressed = OFF)
ENDFUNC

FUNCTION raiseevent(event AS INTEGER)
    IF TABLE(table_applistening) > 0 THEN
        REPEAT
            WA(100)
        UNTIL TABLE(table_eventupdate)=0
        TABLE(table_eventupdate, event)
    ENDIF

ENDFUNC

FUNCTION checkisidle() AS BOOLEAN
    DIM idlecheck AS BOOLEAN
    idlecheck = IDLE AXIS(0) AND IDLE AXIS(1)
    IF (TABLE(comms_numaxes) >= 3) THEN
        idlecheck = idlecheck AND IDLE AXIS(2)
    ENDIF
    IF (TABLE(comms_numaxes) >= 4) THEN
        idlecheck = idlecheck AND IDLE AXIS(3)
    ENDIF

    TABLE(table_idletesting,0)
    TABLE(table_idle, idlecheck)
    RETURN idlecheck
ENDFUNC

FUNCTION getposition()
    TABLE(table_xpos, MPOS AXIS(0))
    TABLE(table_ypos, MPOS AXIS(1))
    TABLE(table_zpos, MPOS AXIS(2))
    TABLE(table_ivpos, MPOS AXIS(3))
ENDFUNC

FUNCTION cyclereset() AS BOOLEAN
    DIM cyclecheck AS BOOLEAN
    cyclecheck = (TABLE(comms_reset) > 0) OR (TABLE(table_estoppressed) > 0)
    RETURN cyclecheck
    'RETURN FALSE
ENDFUNC
